<?php

namespace Admin\Service\Common\PhoneSms;


use Admin\Data\Common;
use Laminas\Json\Json;

class Ihuyi
{
    
    private $sendUrl = 'https://api.ihuyi.com/sms/Submit.json?';
    private $smsConfig;


    /**
     * 设置短信
     * @param $smsConfig
     * @throws ClientException
     */
    public function setSmsConfig($smsConfig)
    {
        $this->smsConfig = $smsConfig;
    }

    /**
     * 发送短信
     * @param array $data
     * @return bool
     */
    public function sendPhoneSms(array $data)
    {
        $smsContent = $this->getSmsContent($data['typeCode'], $data['contentArray'], $data['templateCode']);
        if (empty($smsContent)) return;
        if (empty($data['phone'])) return;
        foreach ($data['phone'] as $phoneValue) {
            $this->sendIhuyi($phoneValue['number'], $smsContent);
        }
    }

    /**
     * 发送订单短信
     * @param array $data
     * @return bool
     */
    public function sendOrderPhoneSms(array $data)
    {
        $smsContent = $this->getSmsContent($data['typeCode'], $data['contentArray'], $data['templateCode']);
        if (empty($smsContent)) return;
        if (empty($data['phone'])) return;

        foreach ($data['phone'] as $phoneValue) {
            $this->sendIhuyi($phoneValue['number'], $smsContent);
        }
    }

      /**
     * 发送短信方法
     * @param $phone
     * @param $content
     * @return array|bool|string|null
     */
    private function sendIhuyi($phone, $content)
    {
        $statusStr = array(
                "0" => "提交失败",
                "2" => "短信发送成功",
                "401" => "APIID不能为空",
                "402" => "APIKEY不能为空",
                "403" => "手机号码不能为空",
                "405" => "APIID 或 APIKEY 不正确",
                "4051" => "剩余条数不足",
                "4052" => "访问 ip 与备案 ip 不符",
                "406" => "手机格式不正确",
                "407" => "短信内容含有敏感字符",
                "4070" => "签名格式不正确"
            );

        try {
            $user = $this->smsConfig['sms_id'];
            $pass = $this->smsConfig['sms_secret'];
            $content = $content;
            $sendurl = $this->sendUrl."account=" . $user . "&password=" . $pass . "&mobile=" . $phone . "&content=" . urlencode($content);
            $result = $this->curl_get($sendurl);
            return $statusStr[json_decode($result, true)['code']];
        } catch (\Exception $e) {
            return null;
        }

        return null;
    }

     private function curl_get($sendurl){
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $sendurl);
        curl_setopt($ch, CURLOPT_TIMEOUT, 1);
        curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER["HTTP_USER_AGENT"]);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

  

      /**
     * 获取短信内容
     * @param $type
     * @param $data
     * @param $templateCode
     * @return string
     */
    private function getSmsContent($type, $data, $templateCode)
    {
        $TemplateCodeContent = '';
        switch ($type) {
            case 'captcha':
                $TemplateCodeContent = str_replace('{code}', $data['phoneCaptcha'], $templateCode);
                break;
            case 'addOrder':
                $TemplateCodeContent = str_replace(['{buyName}', '{orderSn}', '{orderTotal}'], [$data['buyName'], $data['orderSn'], $data['orderTotal']], $templateCode);
                break;
            case 'cancelOrder':
                $TemplateCodeContent = str_replace(['{buyName}', '{orderSn}', '{orderTotal}'], [$data['buyName'], $data['orderSn'], $data['orderTotal']], $templateCode);
                break;
            case 'paymentOrder':
                $TemplateCodeContent = str_replace(['{buyName}', '{orderSn}', '{orderTotal}'], [$data['buyName'], $data['orderSn'], $data['orderTotal']], $templateCode);
                break;
            case 'shipOrder':
                $TemplateCodeContent = str_replace(['{buyName}', '{orderSn}', '{orderTotal}', '{deliveryName}', '{expressNumber}'], [$data['buyName'], $data['orderSn'], $data['orderTotal'], $data['deliveryName'], $data['expressNumber']], $templateCode);
                break;
            case 'receiptOrder':
                $TemplateCodeContent = str_replace(['{buyName}', '{orderSn}', '{orderTotal}', '{deliveryName}', '{expressNumber}'], [$data['buyName'], $data['orderSn'], $data['orderTotal'], $data['deliveryName'], $data['expressNumber']], $templateCode);
                break;
        }

        return $TemplateCodeContent;
    }
}