import java.io.*;
import java.net.*;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public class Main {

    private static final String iUrl = "https://api.ihuyi.com/idcard/operator2id/Submit.json";

    public static void main(String[] args) {
        System.out.println("开始请求!");
        int mobile_code = (int)((Math.random()*9+1)*100000);
        String app = "operator2id";
        String account = "xxxxxxxxx";
        String password = "xxxxxxxxxxxxxxxx";
        String id_card_no = "410XXXXXXXXXXXXXXXXXXX";
		String mobile = "13600000000";
        String currentTime = "" + (System.currentTimeMillis() / 1000L);
        String password_raw = account + password + id_card_no + mobile + currentTime;
        String passwordMd5 = MD5Encode(password_raw);
        String param = "account="+account+"&password="+passwordMd5+"&app="+app+"&id_card_no="+id_card_no+"&mobile="+mobile+"&time="+currentTime;
        String res = sendPost(iUrl, param);
        System.out.println(res);
    }

    /**
     * 向指定 URL 发送POST方法的请求
     *
     * @param url 发送请求的 URL
     * @param param 请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
     * @return 所代表远程资源的响应结果
     */
    public static String sendPost(String url, String param)
    {
        PrintWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try{
            URL realUrl = new URL(iUrl);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("Accept-Charset", "utf-8");
            conn.setRequestProperty("contentType", "utf-8");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            String line;
            while ((line = in.readLine()) != null){
                result.append(line);
            }
            System.out.println("result:" + result);
        }catch (ConnectException e){
            System.out.println("调用sendPost ConnectException, url=" + url + ",param=" + param + e);
        }catch (SocketTimeoutException e){
            System.out.println("调用sendPost SocketTimeoutException, url=" + url + ",param=" + param + e);
        }catch (IOException e){
            System.out.println("调用sendPost IOException, url=" + url + ",param=" + param + e);
        }catch (Exception e){
            System.out.println("调用sendPost Exception, url=" + url + ",param=" + param + e);
        }finally{
            try{
                if (out != null){
                    out.close();
                }
                if (in != null){
                    in.close();
                }
            }catch (IOException ex){
                System.out.println("调用in.close Exception, url=" + url + ",param=" + param + ex);
            }
        }
        return result.toString();
    }

    //md5加密
    private final static String[] hexDigits = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F" };
    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0)
            n = 256 + n;
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }
    public static String byteArrayToHexString(byte[] b) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; i++) {
            resultSb.append(byteToHexString(b[i]));
        }
        return resultSb.toString();
    }
    public static String MD5Encode(String origin) {
        String resultString = null;
        try {
            resultString = new String(origin);
            MessageDigest md = MessageDigest.getInstance("MD5");
            resultString = byteArrayToHexString(md.digest(resultString
                    .getBytes()));
        } catch (Exception ex) {
        }
        return resultString;
    }

}