<?php
namespace crmeb\services\sms\storage;


use crmeb\services\sms\BaseSms;
use crmeb\services\HttpService;
use think\exception\ValidateException;
use think\facade\Config;
use app\services\message\SystemNotificationServices;

class Ihuyi extends BaseSms
{

    protected $status;

    /**
     * 发送模板id
     * @var array
     */
    protected $templateIds = [];

    /**
     * @var string
     */
    protected $accessKeyId = '';

    /**
     * @var string
     */
    protected $accessKeySecret = '';


    protected $signName = '';


    /**
     * @var string
     */
    protected $region = "ap-guangzhou";


    /**
     * @param array $config
     * @return mixed|void
     */
    protected function initialize(array $config = [])
    {
        parent::initialize($config);
        $this->accessKeyId = sys_config('ihuyi_user', '');
        $this->accessKeySecret = sys_config('ihuyi_pwd', '');
        if ($this->accessKeyId && $this->accessKeySecret) {
            $this->status = true;
        } else {
            $this->status = false;
        }
    }

    /**
     * 提取模板code
     * @param string $templateId
     * @return null
     */
    protected function getTemplateCode(string $templateId)
    {
        $notifyServices = app()->make(SystemNotificationServices::class);
        $template = $notifyServices->value([
            'sms_id' => $templateId,
            ], 'system_text') ?? 0;
        return $template ?? null;
    }

    /**
     * @param string $phone
     * @param string $templateId
     * @param array $data
     * @return mixed|void
     */
    public function send(string $phone, string $templateId, array $data)
    {
        $statusStr = array(
            "0" => "提交失败",
            "2" => "短信发送成功",
            "401" => "APIID不能为空",
            "402" => "APIKEY不能为空",
            "403" => "手机号码不能为空",
            "405" => "APIID 或 APIKEY 不正确",
            "4051" => "剩余条数不足",
            "4052" => "访问 ip 与备案 ip 不符",
            "406" => "手机格式不正确",
            "407" => "短信内容含有敏感字符",
            "4070" => "签名格式不正确"
        );

        $smsapi = "https://api.ihuyi.com/sms/Submit.json";
        $user = $this->accessKeyId;
        $pass = md5($this->accessKeySecret);
        $content = $this->getTemplateCode($templateId);
        foreach (array_keys($data) as $k=>$v){
            $search = '{'.$v.'}';
            $content = str_replace($search,$data[$v],$content);
        }
        $sendurl = $smsapi."?account=".$user."&password=".$pass."&mobile=".$phone."&content=".urlencode($content);
        $result = $this->fetchContent($sendurl,'POST','') ;
        $result = json_decode($result,true)['code'];
        try {
            if($result == '0'){
                return true;
            }else{
                throw new ValidateException($statusStr[$result]);
            }
        }catch (\Exception $e) {
            throw new ValidateException($e->getMessage());
        }
    }

    private function fetchContent($url, $method, $body) {
        $ch = curl_init();

        if($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1);//post提交方式
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        } else {
            $url .= '?'.$body;
        }

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "x-sdk-client" => "php/2.0.0"
        ));

        if(substr($url, 0,5) == 'https') {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        }

        $rtn = curl_exec($ch);

        if($rtn === false) {
            // 大多由设置等原因引起，一般无法保障后续逻辑正常执行，
            // 所以这里触发的是E_USER_ERROR，会终止脚本执行，无法被try...catch捕获，需要用户排查环境、网络等故障
            trigger_error("[CURL_" . curl_errno($ch) . "]: " . curl_error($ch), E_USER_ERROR);
        }
        curl_close($ch);

        return $rtn;
    }


    public function open()
    {
        // TODO: Implement open() method.
    }

    public function modify(string $sign = null, string $phone = '', string $code = '')
    {
        // TODO: Implement modify() method.
    }

    public function info()
    {
        // TODO: Implement info() method.
    }

    public function temps(int $page, int $limit, int $type)
    {
        // TODO: Implement temps() method.
    }

    public function apply(string $title, string $content, int $type)
    {
        // TODO: Implement apply() method.
    }

    public function applys(int $tempType, int $page, int $limit)
    {
        // TODO: Implement applys() method.
    }

    public function record($record_id)
    {
        // TODO: Implement record() method.
    }
}
