<?php
namespace app\common\service;

class Sms
{
    /**
     * 发送短信
     * @param string $tel
     * @param string $tpl
     * @param array $param
     * @return mixed|void
     */
    public function sendSms(string $tel = '', string $tpl = '', array $param = [])
    {
        $type = config('sms.type');
        $appId = config('sms.appCode');
        $appSecret = config('sms.appSecret');
        // $signId = config('sms.signId');
        $time = time();
        // $randStr = makeRandStr();

        switch ($type)
        {
            //短信宝
            case 0 :
			    $statusStr = array(
			                "0" => "提交失败",
                            "2" => "短信发送成功",
                            "401" => "APIID不能为空",
                            "402" => "APIKEY不能为空",
                            "403" => "手机号码不能为空",
                            "405" => "APIID 或 APIKEY 不正确",
                            "4051" => "剩余条数不足",
                            "4052" => "访问 ip 与备案 ip 不符",
                            "406" => "手机格式不正确",
                            "407" => "短信内容含有敏感字符",
                            "4070" => "签名格式不正确"
			            );
				$content = str_replace('{code}', $param[0], $tpl);
                $content = preg_replace('/【.*?】/u', '', $content);
				$result  = curlPost("https://api.ihuyi.com/sms/Submit.json?account=".$appId."&password=".$appSecret."&mobile=".$tel."&content=".urlencode($content));
				$res = [
					'result'=> json_decode($result, true)['code'],
					'errmsg'=> $statusStr[json_decode($result, true)['code']]
				];
				return $res;
                break;
        }
    }

}