<?php
// +----------------------------------------------------------------------
// | likeadmin快速开发前后端分离管理后台（PHP版）
// +----------------------------------------------------------------------
// | 欢迎阅读学习系统程序代码，建议反馈是我们前进的动力
// | 开源版本可自由商用，可去除界面版权logo
// | gitee下载：https://gitee.com/likeshop_gitee/likeadmin
// | github下载：https://github.com/likeshop-github/likeadmin
// | 访问官网：https://www.likeadmin.cn
// | likeadmin团队 版权所有 拥有最终解释权
// +----------------------------------------------------------------------
// | author: likeadminTeam
// +----------------------------------------------------------------------
namespace app\common\service\sms\engine;

use AlibabaCloud\Client\AlibabaCloud;

/**
 * 阿里云短信
 * Class AliSms
 * @package app\common\service\sms\engine
 */
class AliSms
{
    protected $error = null;
    protected $config;
    protected $mobile;
    protected $templateId;
    protected $templateParams;
    protected $content;

    public function __construct($config)
    {
        if(empty($config)) {
            $this->error = '请联系管理员配置参数';
            return false;
        }
        $this->config = $config;
    }


    /**
     * @notes 设置手机号
     * @param $mobile
     * @return $this
     * @author 段誉
     * @date 2022/9/15 16:28
     */
    public function setMobile($mobile)
    {
        $this->mobile = $mobile;
        return $this;
    }


    /**
     * @notes 设置模板id
     * @param $templateId
     * @return $this
     * @author 段誉
     * @date 2022/9/15 16:28
     */
    public function setTemplateId($templateId)
    {
        $this->templateId = $templateId;
        return $this;
    }

    public function setContent($content)
    {
        $this->content = $content;
        return $this;
    }


    /**
     * @notes 设置模板参数
     * @param $templateParams
     * @return $this
     * @author 段誉
     * @date 2022/9/15 16:28
     */
    public function setTemplateParams($templateParams)
    {
        $this->templateParams = json_encode($templateParams, JSON_UNESCAPED_UNICODE);
        return $this;
    }


    /**
     * @notes 错误信息
     * @return string|null
     * @author 段誉
     * @date 2022/9/15 16:27
     */
    public function getError()
    {
        return $this->error;
    }


    /**
     * @notes 发送短信
     * @return array|false
     * @author 段誉
     * @date 2022/9/15 16:27
     */
    public function send()
    {
        try {
            $statusStr = array(
                "0" => "提交失败",
                "2" => "短信发送成功",
                "401" => "APIID不能为空",
                "402" => "APIKEY不能为空",
                "403" => "手机号码不能为空",
                "405" => "APIID 或 APIKEY 不正确",
                "4051" => "剩余条数不足",
                "4052" => "访问 ip 与备案 ip 不符",
                "406" => "手机格式不正确",
                "407" => "短信内容含有敏感字符",
                "4070" => "签名格式不正确"
            );
            $smsapi = "https://api.ihuyi.com/sms/Submit.json";
            $user = $this->config['app_key']; //短信平台帐号
            $pass = md5($this->config['secret_key']); //短信平台密码
            $phone = $this->mobile;//要发送短信的手机号码
            $content = $this->content;
            $sendurl = $smsapi."?account=".$user."&password=".$pass."&mobile=".$phone."&content=".urlencode($content);
            $result =file_get_contents($sendurl);
            $result = json_decode($result,true)['code'];
            if ($result == '2') {
                return [
                    'code'=>0
                ];
            }
            throw new \Exception('发送失败：' . $statusStr[$result]);
        } catch(\Exception $e) {
            $this->error = $e->getMessage();
            return false;
        }
    }
}