<?php
namespace core\sms;

use core\exception\NoticeException;
use Exception;


class Ihuyi extends BaseSms
{

    protected $username = '';
    protected $secret_key = '';
    protected $smsapi = "https://api.ihuyi.com/sms/Submit.json";
    protected $statusStr = array(
        "0" => "提交失败",
        "2" => "短信发送成功",
        "401" => "APIID不能为空",
        "402" => "APIKEY不能为空",
        "403" => "手机号码不能为空",
        "405" => "APIID 或 APIKEY 不正确",
        "4051" => "剩余条数不足",
        "4052" => "访问 ip 与备案 ip 不符",
        "406" => "手机格式不正确",
        "407" => "短信内容含有敏感字符",
        "4070" => "签名格式不正确"
        );

    /**
     * @param array $config
     * @return void
     */
    protected function initialize(array $config = [])
    {
        parent::initialize($config);
        $this->username = $config[ 'username' ] ?? '';
        $this->secret_key = $config[ 'secret_key' ] ?? '';
    }


    /**
     * 发送短信
     * @param string $mobile
     * @param string $template_id
     * @param array $data
     * @return array
     */
    public function send(string $mobile, string $template_id, array $data = [])
    {
        try {
            $search = array_map(function($key) {
                return '{' . $key . '}'; // 将键转换为 {key} 形式
            }, array_keys($data));
            
            $replace = array_values($data); // 替换内容为数组的值
            // 执行替换
            $content = str_replace($search, $replace, $template_id);
            $url = $this->smsapi.'?account='.$this->username.'&password='.$this->secret_key.'&mobile='.$mobile.'&content='.$content;
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30 );
            $response = curl_exec($ch);
            curl_close($ch);
            throw new NoticeException($this->statusStr[json_decode($response, true)['code']]);
        } catch (Exception $e) {
            throw new NoticeException($e->getMessage());
        }
    }

    public function modify(string $sign, string $mobile, string $code)
    {
    }

    public function template(int $page = 0, int $limit = 10, int $type = 1)
    {
    }

    public function apply(string $title, string $content, int $type)
    {
    }

    public function localTemplate(int $type, int $page, int $limit)
    {
    }

    public function record($id)
    {
    }
}