<?php
namespace strategy\sms\impl;

use Darabonba\OpenApi\Models\Config;
use strategy\sms\SmsInterface;
use think\facade\Log;

class IhuyiSmsImpl implements SmsInterface
{
    private $sendUrl = 'https://api.ihuyi.com/sms/Submit.json';

    private $statusStr = array(
               "0" => "提交失败",
                "2" => "短信发送成功",
                "401" => "APIID不能为空",
                "402" => "APIKEY不能为空",
                "403" => "手机号码不能为空",
                "405" => "APIID 或 APIKEY 不正确",
                "4051" => "剩余条数不足",
                "4052" => "访问 ip 与备案 ip 不符",
                "406" => "手机格式不正确",
                "407" => "短信内容含有敏感字符",
                "4070" => "签名格式不正确"
            );

     private function curl_get($sendurl){
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $sendurl);
        curl_setopt($ch, CURLOPT_TIMEOUT, 1);
        curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER["HTTP_USER_AGENT"]);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }
 
    public function send($param)
    {
        try {
            $user = $param["accessKeyId"];
            $apikey = $param["accessKeySecret"];
            $codeStr = $param["code"];
            $codeData = json_decode($codeStr,true);
            $TemplateContent = str_replace('{code}', $codeData['code'], $param["templateCode"]);
            $content = $TemplateContent;
            $sendurl = $this->sendUrl."?account=".$user."&password=".$apikey."&mobile=".$param["phone"]."&content=".urlencode($content);
            $result = $this->curl_get($sendurl);
            $result = json_decode($result,true);
            $result = $result['code'];
            if ($result == 2) {
                return dataReturn(0, '发送成功');
            }else{
                 return dataReturn(-1, '发送失败:'.$this->statusStr[$result]);
            }
        } catch (\Exception $error) {
            Log::error("短信失败：" . $error->getMessage());
            return dataReturn(-1, '发送失败');
        }

        return dataReturn(0, '发送成功');
    }
}