<?php
namespace sms\ihuyi;

use app\admin\lib\Plugin;


class IhuyiPlugin extends Plugin
{
    # 基础信息
    public $info = array(
        'name'        => 'Ihuyi',
        'title'       => '互亿无线短信服务',
        'description' => '互亿无线短信服务',
        'status'      => 1,
        'author'      => '互亿无线',
        'version'     => '1.0',
        'help_url'     => 'https://user.ihuyi.com/new/p.html?c=zjmfcw',//申请接口地址
    );

    # 插件安装
    public function install()
    {
		//导入模板
		$smsTemplate= [];
		if (file_exists(__DIR__.'/config/smsTemplate.php')){
            $smsTemplate = require __DIR__.'/config/smsTemplate.php';
        }
		
        return $smsTemplate;
    }

    # 插件卸载
    public function uninstall()
    {
        return true;//卸载成功返回true，失败false
    }
	
	# 后台页面创建模板时可用参数
	public function description()
	{
		return file_get_contents(__DIR__.'/config/description.html');    
    } 
	
	#获取国内模板
	public function getCnTemplate($params)
	{				
		$data['status']='success';
		$data['template']['template_status']=2;
		return $data;
	}
	#创建国内模板
	public function createCnTemplate($params)
	{
		$data['status']='success';
		$data['template']['template_status']=2;
		return $data;
	}
	#修改国内模板
	public function putCnTemplate($params)
	{
		$data['status']='success';
		$data['template']['template_status']=2;
		return $data;
	}
	#删除国内模板
	public function deleteCnTemplate($params)
	{
		$data['status']='success';
		return $data;
	}
	#发送国内短信
    public function sendCnSms($params)
    {	   	
        $content=$this->templateParam($params['content'],$params['templateParam']);
		$param['content']=$this->templateSign($params['config']['sign']).$content;
		$param['mobile']=trim($params['mobile']);
        $resultTemplate= $this->APIHttpRequestCURL('cn',$param,$params['config']);
		if($resultTemplate['status']=="success"){
			$data['status']="success";
			$data['content']=$content;
		}else{
			$data['status']="error";
			$data['content']=$content;
			$data['msg']=$resultTemplate['msg'];
		}
		return $data;
    }	
	#获取国际模板
	public function getGlobalTemplate($params)
	{		
		$data['status']='success';
		$data['template']['template_status']=2;
		return $data;
	}
	#创建国际模板
	public function createGlobalTemplate($params)
	{
		$data['status']='success';
		$data['template']['template_status']=2;
		return $data;
	}
	#修改国际模板
	public function putGlobalTemplate($params)
	{
		$data['status']='success';
		$data['template']['template_status']=2;
		return $data;
	}
	#删除国际模板
	public function deleteGlobalTemplate($params)
	{
		$data['status']='success';
		return $data;
	}
	#发送国际短信
    public function sendGlobalSms($params)
    {
    	$content=$this->templateParam($params['content'],$params['templateParam']);
		
		$param['content']=$this->templateSign($params['config']['sign']).$content;
		$param['mobile']=trim($params['mobile']);
        $resultTemplate= $this->APIHttpRequestCURL('global',$param,$params['config']);
		if($resultTemplate['status']=="success"){
			$data['status']="success";
			$data['content']=$content;
		}else{
			$data['status']="error";
			$data['content']=$content;
			$data['msg']=$resultTemplate['msg'];
		}
		return $data;
    }	
	
	# 以下函数名自定义

	private function APIHttpRequestCURL($sms_type = 'cn',$params,$config){
		$url = ($sms_type === 'cn') ? 'https://api.ihuyi.com/sms/Submit.json' : 'https://api.ihuyi.com/isms/Submit.json';
        $statusStr = array(
            "0" => "提交失败",
			"2" => "短信发送成功",
			"401" => "APIID不能为空",
			"402" => "APIKEY不能为空",
			"403" => "手机号码不能为空",
			"405" => "APIID 或 APIKEY 不正确",
			"4051" => "剩余条数不足",
			"4052" => "访问 ip 与备案 ip 不符",
			"406" => "手机格式不正确",
			"407" => "短信内容含有敏感字符",
			"4070" => "签名格式不正确"
        );
        $user = $config['user']; //短信平台帐号
        $pass = $config['pass']; //短信平台密码
        //要发送的短信内容
		$content = preg_replace('/【[^】]*】/u','',$params['content']);
        $phone = $params['mobile'];//要发送短信的手机号码
        $sendurl = $url."?account=".$user."&password=".$pass."&mobile=".$phone."&content=".urlencode($content);
        $result =file_get_contents($sendurl) ;
		$result = json_decode($result,true);
		$result = $result['code'];
        //短信发送成功返回True，失败返回false
        if ($result  == '2') {
            return array('status' => "success", 'msg' => $statusStr[$result]);
        } else {
            return array('status' => "error", 'msg' =>  $statusStr[$result] . '. Code: ' . $result);
        }
    }

    private function templateParam($content,$templateParam){
        foreach ($templateParam as $key => $para) {
            $content = str_replace('{' . $key . '}', $para, $content);//模板中的参数替换
        }       
        return $content;
    }
	private function templateSign($sign){
		$sign = str_replace("【","",$sign);
		$sign = str_replace("】","",$sign);
		$sign = "【".$sign."】";  
        return $sign;
    }
}