<?php
namespace addons\Ihuyi;	// 注意命名空间规范

use myxland\addons\Addons;
use app\common\model\Addons as addonsModel;

/**
 * mms1086短信通道
 */
class Ihuyi extends Addons
{
    // 该插件的基础信息
    public $info = [
        'name' => 'Ihuyi',	// 插件标识
        'title' => '互亿无线短信插件',	// 插件名称
        'description' => '互亿无线发送短信插件，请勿和其它短信通道一起使用',	// 插件简介
        'status' => 0,	// 状态
        'author' => 'xiaoyi',
        'version' => '0.1'
    ];

    /**
     * 插件安装方法
     * @return bool
     */
    public function install()
    {
        return true;
    }

    /**
     * 插件卸载方法
     * @return bool
     */
    public function uninstall()
    {
        return true;
    }

    /**
     * 实现的testhook钩子方法
     * @return mixed
     */
    public function sendsms($params)
    {
        $result     = [
            'status' => false,
            'data'   => [],
            'msg'    => '发送失败'
        ];
        $addonModel = new addonsModel();
        $setting    = $addonModel->getSetting($this->info['name']);
        if ($params['params']['code'] == 'seller_order_notice') {
            $params['params']['mobile'] = getSetting('shop_mobile');
            if (!$params['params']['mobile']) {
                $result['msg'] = '商户手机号不存在';
                return $result;
            }
        }
        $sms_password = $setting['sms_password'];     //为了演示效果，此密码从配置文件中取，如果正式使用，请删除此行，并在后台店铺设置里配置密码即可。
        $content      =  $params['params']['content'] ;
        //$content = iconv("utf-8","gb2312",$content);
        $content = urlencode($content);      //内容
        $smsapi = "http://106.ihuyi.com/webservice/sms.php";
        $postdata = "method=Submit&account=".$setting['sms_account']."&password=".$sms_password."&mobile=".$params['params']['mobile']."&content=".$content;
        //互亿无线结束
        if (extension_loaded('curl')){
            $file_contents = $this->curl_post($smsapi,$postdata);
        }else if(function_exists('file_get_contents')){
            $file_contents = file_get_contents($smsapi.'?'.$postdata);
        }
        $res = $this->xml_to_array($file_contents);
        if(isset($res['SubmitResult'])) {
            if($res['SubmitResult']['code'] == 2) {
                $result['msg']    = '发送成功';
                $result['status'] = true;
            } else {
                $result['msg']    = '发送失败';
                $result['status'] = false;
            }
        } else {
            $result['msg']    = '发送失败';
            $result['status'] = false;
        }
        return $result;
    }

    public function config($params = [])
    {
        $this->assign('config', $params);
        return $this->fetch('config');
    }
    function curl_post($url,$curlPost){
        $curl = curl_init();


        if (is_array($curlPost))
        {
            $curlPost = http_build_query($curlPost, '', '&');
        }


        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_TIMEOUT, 10);//超时时间
        curl_setopt($curl, CURLOPT_NOBODY, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $curlPost);


        if (strpos($url, "https") === 0){//访问SSL协议的URL https://
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); // 是否验证ssl证书
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0); // 0表示不检查证书；1表示检查证书中是否有CN(common name)字段；2表示在1的基础上校验当前的域名是否与CN匹配
        }


        $return_str = curl_exec($curl);

        curl_close($curl);
        return $return_str;
    }

    //互亿无线开始
    function xml_to_array($xml){
        $arr = array();
        $reg = "/<(\w+)[^>]*>([\\x00-\\xFF]*)<\\/\\1>/";
        if(preg_match_all($reg, $xml, $matches)){
            $count = count($matches[0]);
            for($i = 0; $i < $count; $i++){
                $subxml= $matches[2][$i];
                $key = $matches[1][$i];
                if(preg_match( $reg, $subxml )){
                    $arr[$key] = $this->xml_to_array( $subxml );
                }else{
                    $arr[$key] = $subxml;
                }
            }
        }
        return $arr;
    }
    //互亿无线结束

}
