<?php
/**
 * @brief 短信发送接口
 * @author soils
 * @date 2021-06-23 09:52
 * @version 1.1
 */

 /**
 * @brief 短信发送接口 
 */
class ihuyi extends hsmsBase
{
	private $submitUrl  = "https://106.ihuyi.com/webservice/sms.php?method=Submit";

	/**
	 * @brief 获取config用户配置
	 * @return array
	 */
	public function getConfig()
	{
		$siteConfigObj = new Config("site_config");

		return array(
			'username' => $siteConfigObj->sms_username,
			'userpwd'  => $siteConfigObj->sms_pwd,
		);
	}

	/**
     * @brief 获取参数
     */
    public function getParam()
    {
        return array(
            "username" => "用户名",
            "userpwd"  => "密码",
        );
    }

	/**
	 * @brief 发送短信
	 * @param string $mobile
	 * @param string $content
	 * @return
	 */
	public function send($mobile,$content)
	{
		$config = self::getConfig();

		$postData = array(
			'account' => $config['username'],
			'password' => $config['userpwd'],
			'content'  => $content,
			'mobile'   => $mobile,
		);

		$get = $this->_https_request($this->submitUrl,$postData);
        $gets =  $this->xml_to_array($get);
        if($gets['SubmitResult']['code']!=2){
            return $gets['SubmitResult']['msg'].' 短信发送失败，请联系服务商！';
        } else {
            return 'success';
        }
	}

	//互亿无线
    public function xml_to_array($xml){
        $reg = "/<(\w+)[^>]*>([\\x00-\\xFF]*)<\\/\\1>/";
        if(preg_match_all($reg, $xml, $matches)){
            $count = count($matches[0]);
            for($i = 0; $i < $count; $i++){
            $subxml= $matches[2][$i];
            $key = $matches[1][$i];
                if(preg_match( $reg, $subxml )){
                    $arr[$key] = $this->xml_to_array( $subxml );
                }else{
                    $arr[$key] = $subxml;
                }
            }
        }
        return $arr;
    }

    //互亿无线
	public function _https_request($url,$data = null){
		if(function_exists('curl_init')){
			$curl = curl_init();
		    if (is_array($data)) {
                $curlPost = http_build_query($data, '', '&');
            }
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_TIMEOUT, 10);//超时时间
            curl_setopt($curl, CURLOPT_NOBODY, true);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $curlPost);
		    if (strpos($url, "https") === 0){//访问SSL协议的URL https://
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); // 是否验证ssl证书
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0); // 0表示不检查证书；1表示检查证书中是否有CN(common name)字段；2表示在1的基础上校验当前的域名是否与CN匹配
            }
            $return_str = curl_exec($curl);
            curl_close($curl);
            return $return_str;
		}else{
			$this->_error = '短信发送失败，请开启curl服务！';
			return false;
		}
	}

	/**
	 * @brief 解析结果
	 * @param $result 发送结果
	 * @return string success or fail
	 */
	public function response($result)
	{
	    $resArray = JSON::decode($result);
		if(!$resArray)
		{
			return '返回json数据异常：'.$result;
		}

		if($resArray['msg'] == 'success')
		{
		    return 'success';
		}
		return $resArray['msg'];
	}


}